/*
 * CS 3114 Project 2
 * Author: Kevin Lee
 * Compiler: Eclipse 3.7.0
 * Operating System: Windows 7 x64
 * Date Completed: 10/7/2011
 * 
 * The following program is an implementation of two different
 * trees that allows for efficient storing of records with
 * coordinates. A binary search tree is used to allow for
 * efficient search by name, while a point region quad tree is
 * used to allow for efficient search by coordinates. The 
 * program parses an input file for commands, and outputs the
 * results to standard out.
 * 
 * On my honor:
 *
 * - I have not used source code obtained from another student,
 * or any other unauthorized source, either modified or
 * unmodified.
 *
 * - All source code and documentation used in my program is
 * either my original work, or was derived by me from the
 * source code published in the textbook for this course.
 *
 * - I have not discussed coding details about this project with
 * anyone other than my partner (in the case of a joint
 * submission), instructor, ACM/UPE tutors or the TAs assigned
 * to this course. I understand that I may discuss the concepts
 * of this program with other students, and that another student
 * may help me debug my program so long as neither of us writes
 * anything during the discussion or modifies any computer file
 * during the discussion. I have violated neither the spirit nor
 * letter of this restriction.
 */

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public class PRProg {

	public static void main(String[] args) {

		String input_commandFile; // Location of file to parse

		// 3 arguments must be supplied to the program
		if (args.length != 1) {
			System.out.println("1 Arguments must be supplied!");
			return;
		}

		// Parses passed arguments into member variables
		input_commandFile = args[0];

		// Check to make sure the command file exists
		File cmdFile = new File(input_commandFile);
		if (!cmdFile.exists()) {
			System.out.printf("Command file not found");
			return;
		}
		
		CmdParser GISParser = new CmdParser();
		
		// Parse each command with the memory client
		try {
			BufferedReader reader = new BufferedReader(new FileReader(cmdFile));
			String cin;
			while ((cin = reader.readLine()) != null) {
				cin = cin.trim();
				if (cin.length() != 0) {
					// Send string to command parser
					GISParser.Parse(cin);
				}
			}
		} catch (FileNotFoundException e) {
			System.out.printf("Command file not found");
			return;
		} catch (IOException e) {
			System.out.printf("Unable to read input file");
			return;
		}
	}
}
